# Personalized Subgraph Federated Learning

## Requirement
- Python 3.8.x
- PyTorch 1.9.0
- PyTorch Geometric 2.0.x
- METIS (for data generation), https://github.com/james77777778/metis_python

## Data Generation
Following command lines automatically generate the dataset, `Cora for the Non-overlapping Node Scenario`.
```sh
$ cd data/generators
$ python real_total_split_disjoint.py
```

## Run 
```sh
$ sh run.sh [gpus] [num_workers] [model] [task] [trial]
```

- `gpus`: specify gpus to use
- `num workers`: specify the number of workers that will be run on gpus (e.g. if your experiment uses 10 clients for every round then use less than or equal to 10 workers). The actual number of workers will be `num_workers` + 1 (one additional worker for a server)
- `model`: give model name e.g. fedavg 
- `task`: give task e.g. Cora_CC_total_0.2_HET
- `trial`: this will be used for folder name when logging

Example
```sh
$ sh run.sh 0,1 5 fedpub Cora_CC_total_0.2_HET test
```
